//------------------------------------------------------------------------------
// File: svr_tech.cs
// This file is used the tech and tech tree scripts
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Gets the desired tech tree
//! \param %client Client id
//! \param %techTreeName Name of tech tree
////////////////////////////////////////////////////////////////////////////////
function SLTechManager::getTechTree(%this, %client, %techTreeName)
{
   %tech = GameTechManager.getTech(%client);
   if(isObject(%tech)) {
      return %tech.getTree(%techTreeName);
   }
   else {
      return 0;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Updates the tech tree for a specified client
//! \param %client Client
//! \param %tree Name of tree to update in tech
////////////////////////////////////////////////////////////////////////////////
function SLTechManager::updateTech(%this, %client, %tree)
{
   // Gets the tech tree from the client tech
   %techTree = %this.getTechTree(%client, %tree);
   
   // Update tech tree
   if(isObject(%techTree)) {
      %techTree.updateTree(%client);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Resets the tech to default settings for a specified client
//! \param %client Client for which to reset tech
////////////////////////////////////////////////////////////////////////////////
function SLTechManager::resetTech(%this, %client)
{
   if(!isObject(%client)) {
      return;
   }
   
   // Gets the tech tree from the client tech
   %tech = %this.getTech(%client);
   %tech.resetTrees(%client);
}

////////////////////////////////////////////////////////////////////////////////
//! \brief Called when a vertex is successfully changed
//! \param %client Client whose vertex has changed
//! \param %techType Type of building whose tech vertex has changed
//! \param %oldState Previous state
//! \param %newState New state
////////////////////////////////////////////////////////////////////////////////
function SLTechTree::onVertexChange(%this, %client, %techType, %oldState, %newState)
{
   %bAvailable = (%newState == $TECHV_AVAIL || %newState == $TECHV_BUILT);
   commandToClient(%client, 'OnTechChange', %techType, %bAvailable);
}

// End svr_tech.cs